/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.TripodfishEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class TripodfishModel
extends AdvancedEntityModel<TripodfishEntity> {
    private final AdvancedModelBox mainBody;
    private final AdvancedModelBox dorsalfin;
    private final AdvancedModelBox bfin;
    private final AdvancedModelBox rpectoralFin;
    private final AdvancedModelBox lpectoralFin;
    private final AdvancedModelBox lpelvicFin;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox rpelvicFin;
    private final AdvancedModelBox cube_r2;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox ttailFin;
    private final AdvancedModelBox btailFin;

    public TripodfishModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.mainBody = new AdvancedModelBox((AdvancedEntityModel)this);
        this.mainBody.setRotationPoint(0.0f, 22.0f, -2.25f);
        this.mainBody.setTextureOffset(0, 0).addBox(-1.5f, -3.0f, -3.75f, 3.0f, 5.0f, 11.0f, 0.0f, false);
        this.mainBody.setTextureOffset(26, 24).addBox(-1.5f, -1.0f, -7.75f, 3.0f, 3.0f, 4.0f, 0.0f, false);
        this.dorsalfin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.dorsalfin.setRotationPoint(0.0f, -3.0f, 1.25f);
        this.mainBody.addChild((BasicModelPart)this.dorsalfin);
        this.dorsalfin.setTextureOffset(0, 7).addBox(0.0f, -5.0f, -1.0f, 0.0f, 6.0f, 9.0f, 0.0f, false);
        this.bfin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bfin.setRotationPoint(0.0f, 2.0f, 3.75f);
        this.mainBody.addChild((BasicModelPart)this.bfin);
        this.bfin.setTextureOffset(22, 10).addBox(0.0f, -1.0f, -1.5f, 0.0f, 5.0f, 6.0f, 0.0f, false);
        this.rpectoralFin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rpectoralFin.setRotationPoint(-1.5f, -2.0f, -0.75f);
        this.mainBody.addChild((BasicModelPart)this.rpectoralFin);
        this.rpectoralFin.setTextureOffset(17, 0).addBox(-7.0f, -9.0f, 0.0f, 7.0f, 11.0f, 0.0f, 0.0f, true);
        this.lpectoralFin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lpectoralFin.setRotationPoint(1.5f, -2.0f, -0.75f);
        this.mainBody.addChild((BasicModelPart)this.lpectoralFin);
        this.lpectoralFin.setTextureOffset(17, 0).addBox(0.0f, -9.0f, 0.0f, 7.0f, 11.0f, 0.0f, 0.0f, false);
        this.lpelvicFin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lpelvicFin.setRotationPoint(1.5f, 2.0f, -0.25f);
        this.mainBody.addChild((BasicModelPart)this.lpelvicFin);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(0.0f, 0.0f, 1.25f);
        this.lpelvicFin.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, 0.0f, 0.0f, -0.4363f);
        this.cube_r1.setTextureOffset(0, 18).addBox(0.0f, -2.0f, -1.75f, 0.0f, 19.0f, 4.0f, 0.0f, false);
        this.rpelvicFin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rpelvicFin.setRotationPoint(-1.5f, 2.0f, -0.25f);
        this.mainBody.addChild((BasicModelPart)this.rpelvicFin);
        this.cube_r2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r2.setRotationPoint(0.0f, 0.0f, 1.25f);
        this.rpelvicFin.addChild((BasicModelPart)this.cube_r2);
        this.setRotateAngle(this.cube_r2, 0.0f, 0.0f, 0.4363f);
        this.cube_r2.setTextureOffset(0, 18).addBox(0.0f, -2.0f, -1.75f, 0.0f, 19.0f, 4.0f, 0.0f, true);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, -0.5f, 6.75f);
        this.mainBody.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(10, 16).addBox(-1.0f, -2.0f, 0.5f, 2.0f, 4.0f, 8.0f, 0.0f, false);
        this.ttailFin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.ttailFin.setRotationPoint(0.0f, -1.5f, 8.5f);
        this.tail.addChild((BasicModelPart)this.ttailFin);
        this.ttailFin.setTextureOffset(16, 24).addBox(0.0f, -10.0f, 0.0f, 0.0f, 12.0f, 4.0f, 0.0f, false);
        this.btailFin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.btailFin.setRotationPoint(0.0f, 1.5f, 8.5f);
        this.tail.addChild((BasicModelPart)this.btailFin);
        this.btailFin.setTextureOffset(8, 24).addBox(-0.01f, -1.0f, 0.0f, 0.0f, 17.0f, 4.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.mainBody, (Object)this.bfin, (Object)this.btailFin, (Object)this.tail, (Object)this.dorsalfin, (Object)this.ttailFin, (Object)this.rpectoralFin, (Object)this.lpectoralFin, (Object)this.lpelvicFin, (Object)this.rpelvicFin, (Object)this.cube_r1, (Object)this.cube_r2, (Object[])new AdvancedModelBox[0]);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.mainBody);
    }

    public void setupAnim(TripodfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float landProgress = entity.getLandProgress(partialTicks);
        float standProgress = entity.getStandProgress(partialTicks) * (1.0f - landProgress);
        float swimProgress = 1.0f - standProgress;
        float fishPitchAmount = entity.getFishPitch(partialTicks) / 57.295776f * swimProgress;
        float swimSpeed = 0.8f;
        float swimDegree = 0.6f;
        this.progressRotationPrev(this.mainBody, landProgress, 0.0f, 0.0f, (float)Math.toRadians(85.0), 1.0f);
        this.progressPositionPrev(this.mainBody, standProgress, 0.0f, -15.0f, -1.0f, 1.0f);
        this.progressPositionPrev(this.mainBody, landProgress, 0.0f, -1.0f, -1.0f, 1.0f);
        this.progressPositionPrev(this.rpelvicFin, swimProgress, 0.0f, 0.0f, 1.0f, 1.0f);
        this.progressPositionPrev(this.lpelvicFin, swimProgress, 0.0f, 0.0f, 1.0f, 1.0f);
        this.progressRotationPrev(this.rpelvicFin, swimProgress, (float)Math.toRadians(70.0), 0.0f, (float)Math.toRadians(-30.0), 1.0f);
        this.progressRotationPrev(this.lpelvicFin, swimProgress, (float)Math.toRadians(70.0), 0.0f, (float)Math.toRadians(30.0), 1.0f);
        this.progressRotationPrev(this.ttailFin, swimProgress, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.btailFin, swimProgress, (float)Math.toRadians(40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rpectoralFin, swimProgress, (float)Math.toRadians(-30.0), (float)Math.toRadians(-10.0), (float)Math.toRadians(-70.0), 1.0f);
        this.progressRotationPrev(this.lpectoralFin, swimProgress, (float)Math.toRadians(-30.0), (float)Math.toRadians(10.0), (float)Math.toRadians(70.0), 1.0f);
        this.walk(this.rpectoralFin, 0.15f, 0.3f, false, 1.0f, 0.1f, ageInTicks, swimProgress);
        this.walk(this.lpectoralFin, 0.15f, 0.3f, false, 1.0f, -0.1f, ageInTicks, swimProgress);
        this.bob(this.mainBody, 0.1f, 0.5f, false, ageInTicks, swimProgress);
        this.swing(this.mainBody, swimSpeed, swimDegree * 0.5f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount * swimProgress);
        this.swing(this.tail, swimSpeed, swimDegree * 0.75f, false, -1.0f, 0.0f, limbSwing, limbSwingAmount * swimProgress);
        this.swing(this.ttailFin, swimSpeed, swimDegree * 0.75f, false, -2.0f, 0.0f, limbSwing, limbSwingAmount * swimProgress);
        this.swing(this.btailFin, swimSpeed, swimDegree * 0.75f, false, -2.0f, 0.0f, limbSwing, limbSwingAmount * swimProgress);
        this.walk(this.rpectoralFin, swimSpeed, swimDegree * 0.4f, false, 1.0f, -0.1f, limbSwing, limbSwingAmount * swimProgress);
        this.walk(this.lpectoralFin, swimSpeed, swimDegree * 0.4f, false, 1.0f, 0.1f, limbSwing, limbSwingAmount * swimProgress);
        this.walk(this.rpectoralFin, 0.05f, 0.1f, false, 1.0f, 0.0f, ageInTicks, standProgress);
        this.walk(this.lpectoralFin, 0.05f, 0.1f, false, 1.0f, 0.0f, ageInTicks, standProgress);
        this.walk(this.ttailFin, 0.05f, 0.1f, false, -1.0f, 0.0f, ageInTicks, standProgress);
        this.walk(this.dorsalfin, 0.05f, 0.1f, false, 0.0f, 0.0f, ageInTicks, standProgress);
        this.mainBody.rotateAngleX += fishPitchAmount * 0.9f;
    }
}

