/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import com.google.common.base.Defaults;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionHelper {
    private static final Map<String, Field> FIELDS_CACHE = Maps.newIdentityHashMap();
    private static final Map<String, Method> METHODS_CACHE = Maps.newIdentityHashMap();
    private static final Map<String, Constructor<?>> CONSTRUCTORS_CACHE = Maps.newIdentityHashMap();

    @Nullable
    public static Field findField(Class<?> clazz, String name) {
        return ReflectionHelper.findField(clazz, name, true);
    }

    @Nullable
    public static Field findField(Class<?> clazz, String name, boolean allowCache) {
        return ReflectionHelper.findField(clazz.getTypeName(), name, allowCache);
    }

    @Nullable
    public static Field findField(String typeName, String name, boolean allowCache) {
        Objects.requireNonNull(typeName, "clazz name was null");
        Objects.requireNonNull(name, "field name was null");
        String fieldName = ReflectionHelper.getClassMemberName(typeName, name);
        if (allowCache && FIELDS_CACHE.containsKey(fieldName)) {
            return FIELDS_CACHE.get(fieldName);
        }
        try {
            Field field = Class.forName(typeName).getDeclaredField(name);
            field.setAccessible(true);
            FIELDS_CACHE.put(fieldName, field);
            return field;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            PuzzlesLib.LOGGER.warn("Unable to find field {}", (Object)fieldName, (Object)e);
            FIELDS_CACHE.put(fieldName, null);
            return null;
        }
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ReflectionHelper.findMethod(clazz, name, true, parameterTypes);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, boolean allowCache, Class<?> ... parameterTypes) {
        return ReflectionHelper.findMethod(clazz.getTypeName(), name, allowCache, parameterTypes);
    }

    @Nullable
    public static Method findMethod(String typeName, String name, boolean allowCache, Class<?> ... parameterTypes) {
        Objects.requireNonNull(typeName, "clazz name was null");
        Objects.requireNonNull(name, "method name was null");
        String methodName = ReflectionHelper.getMethodName(typeName, name, parameterTypes);
        if (allowCache && METHODS_CACHE.containsKey(methodName)) {
            return METHODS_CACHE.get(methodName);
        }
        try {
            Method method = Class.forName(typeName).getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            METHODS_CACHE.put(methodName, method);
            return method;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            PuzzlesLib.LOGGER.warn("Unable to find method {}", (Object)methodName, (Object)e);
            METHODS_CACHE.put(methodName, null);
            return null;
        }
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        return ReflectionHelper.findConstructor(clazz, true, parameterTypes);
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(Class<?> clazz, boolean allowCache, Class<?> ... parameterTypes) {
        return ReflectionHelper.findConstructor(clazz.getTypeName(), allowCache, parameterTypes);
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(String typeName, boolean allowCache, Class<?> ... parameterTypes) {
        Objects.requireNonNull(typeName, "clazz name was null");
        String constructorName = ReflectionHelper.getConstructorName(typeName, parameterTypes);
        if (allowCache && CONSTRUCTORS_CACHE.containsKey(constructorName)) {
            return CONSTRUCTORS_CACHE.get(constructorName);
        }
        try {
            Constructor<?> constructor = Class.forName(typeName).getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            CONSTRUCTORS_CACHE.put(constructorName, constructor);
            return constructor;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            PuzzlesLib.LOGGER.warn("Unable to find constructor {}", (Object)constructorName, (Object)e);
            CONSTRUCTORS_CACHE.put(constructorName, null);
            return null;
        }
    }

    public static <T, E> Optional<T> getValue(Class<? super E> clazz, String name, E instance) {
        return ReflectionHelper.getValue(ReflectionHelper.findField(clazz, name), instance);
    }

    public static <T, E> Optional<T> getValue(String typeName, String name, E instance) {
        return ReflectionHelper.getValue(ReflectionHelper.findField(typeName, name, true), instance);
    }

    public static <T, E> boolean setValue(Class<? super E> clazz, String name, E instance, T value) {
        return ReflectionHelper.setValue(ReflectionHelper.findField(clazz, name), instance, value);
    }

    public static <T, E> boolean setValue(String typeName, String name, E instance, T value) {
        return ReflectionHelper.setValue(ReflectionHelper.findField(typeName, name, true), instance, value);
    }

    public static <T> Optional<T> getValue(@Nullable Field field, Object instance) {
        if (field != null) {
            try {
                return Optional.ofNullable(field.get(instance));
            }
            catch (ReflectiveOperationException e) {
                PuzzlesLib.LOGGER.warn("Unable to get field {}", (Object)ReflectionHelper.getFieldName(field), (Object)e);
            }
        }
        return Optional.empty();
    }

    public static <T> boolean setValue(@Nullable Field field, Object instance, T value) {
        if (field != null) {
            try {
                field.set(instance, value);
                return true;
            }
            catch (ReflectiveOperationException e) {
                PuzzlesLib.LOGGER.warn("Unable to set field {}", (Object)ReflectionHelper.getFieldName(field), (Object)e);
            }
        }
        return false;
    }

    public static <T, E> Optional<T> invokeMethod(Class<? super E> clazz, String name, Class<?>[] parameterTypes, E instance, Object[] args) {
        return ReflectionHelper.invokeMethod(ReflectionHelper.findMethod(clazz, name, parameterTypes), instance, args);
    }

    public static <T> Optional<T> invokeMethod(@Nullable Method method, Object instance, Object ... args) {
        if (method != null) {
            try {
                return Optional.ofNullable(method.invoke(instance, args));
            }
            catch (ReflectiveOperationException e) {
                PuzzlesLib.LOGGER.warn("Unable to invoke method {}", (Object)ReflectionHelper.getMethodName(method), (Object)e);
            }
        }
        return Optional.empty();
    }

    public static <T> Supplier<Optional<T>> newDefaultInstanceFactory(Class<T> clazz) {
        Constructor<?> constructor = null;
        for (Constructor<?> currentConstructor : clazz.getConstructors()) {
            if (constructor != null && currentConstructor.getParameterCount() >= constructor.getParameterCount()) continue;
            constructor = currentConstructor;
        }
        if (constructor != null) {
            Object[] args = Stream.of(constructor.getParameterTypes()).map(Defaults::defaultValue).toArray();
            return ReflectionHelper.newInstanceFactory(constructor, args);
        }
        return Optional::empty;
    }

    public static <T, E> Optional<T> newInstance(Class<? super E> clazz, Class<?>[] parameterTypes, Object[] args) {
        return ReflectionHelper.newInstance(ReflectionHelper.findConstructor(clazz, parameterTypes), args);
    }

    public static <T> Supplier<Optional<T>> newInstanceFactory(Class<T> clazz, Class<?>[] parameterTypes, Object[] args) {
        return ReflectionHelper.newInstanceFactory(ReflectionHelper.findConstructor(clazz, parameterTypes), args);
    }

    public static <T> Optional<T> newInstance(@Nullable Constructor<T> constructor, Object ... args) {
        return ReflectionHelper.newInstanceFactory(constructor, args).get();
    }

    public static <T> Supplier<Optional<T>> newInstanceFactory(@Nullable Constructor<T> constructor, Object ... args) {
        if (constructor != null) {
            MethodHandle methodHandle;
            try {
                methodHandle = MethodHandles.publicLookup().unreflectConstructor(constructor);
            }
            catch (IllegalAccessException e) {
                PuzzlesLib.LOGGER.warn("Unable to access constructor {}", (Object)ReflectionHelper.getConstructorName(constructor), (Object)e);
                return Optional::empty;
            }
            return () -> {
                try {
                    return Optional.of(methodHandle.invoke(args));
                }
                catch (Throwable e) {
                    PuzzlesLib.LOGGER.warn("Unable to invoke constructor {}", (Object)ReflectionHelper.getConstructorName(constructor), (Object)e);
                    return Optional.empty();
                }
            };
        }
        return Optional::empty;
    }

    private static String getFieldName(@NotNull Field field) {
        Objects.requireNonNull(field, "Cannot get name for null field");
        return ReflectionHelper.getClassMemberName(field.getDeclaringClass(), field.getName());
    }

    private static String getMethodName(@NotNull Method method) {
        Objects.requireNonNull(method, "Cannot get name for null method");
        return ReflectionHelper.getMethodName(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    private static String getConstructorName(@NotNull Constructor<?> constructor) {
        Objects.requireNonNull(constructor, "Cannot get name for null constructor");
        return ReflectionHelper.getConstructorName(constructor.getDeclaringClass(), constructor.getParameterTypes());
    }

    private static String getConstructorName(Class<?> clazz, Class<?> ... parameterTypes) {
        return ReflectionHelper.getConstructorName(clazz.getTypeName(), parameterTypes);
    }

    private static String getConstructorName(String typeName, Class<?> ... parameterTypes) {
        return ReflectionHelper.getMethodName(typeName, "<init>", parameterTypes);
    }

    private static String getMethodName(Class<?> clazz, String method, Class<?> ... parameterTypes) {
        return ReflectionHelper.getMethodName(clazz.getTypeName(), method, parameterTypes);
    }

    private static String getMethodName(String typeName, String method, Class<?> ... parameterTypes) {
        return ReflectionHelper.getClassMemberName(typeName, ReflectionHelper.toMethodSignature(method, parameterTypes));
    }

    private static String toMethodSignature(String method, Class<?> ... parameterTypes) {
        StringJoiner sj = new StringJoiner(",", method + "(", ")");
        for (Class<?> parameterType : parameterTypes) {
            sj.add(parameterType.getTypeName());
        }
        return sj.toString();
    }

    private static String getClassMemberName(Class<?> clazz, String member) {
        return ReflectionHelper.getClassMemberName(clazz.getTypeName(), member);
    }

    private static String getClassMemberName(String typeName, String member) {
        return (typeName + "." + member).intern();
    }
}

