/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.config;

import com.hypherionmc.craterlib.core.config.AbstractConfig;
import com.hypherionmc.craterlib.core.config.ConfigController;
import com.hypherionmc.craterlib.core.config.annotations.NoConfigScreen;
import com.hypherionmc.craterlib.core.config.formats.AbstractConfigFormat;
import com.hypherionmc.craterlib.core.config.formats.JsonConfigFormat;
import com.hypherionmc.mmode.CommonClass;
import com.hypherionmc.mmode.ModConstants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import shadow.hypherionmc.moonconfig.core.Config;
import shadow.hypherionmc.moonconfig.core.conversion.ObjectConverter;
import shadow.hypherionmc.moonconfig.core.file.FileConfig;

@NoConfigScreen
public final class MaintenanceModeConfig
extends AbstractConfig<MaintenanceModeConfig> {
    public static transient MaintenanceModeConfig INSTANCE;
    public static transient int configVer;
    public static transient boolean hasConfigLoaded;
    public static transient boolean wasReload;
    private boolean enabled = false;
    private boolean doBackup = false;
    private String message = "This server is currently in maintenance mode! Please check back later";
    private String motd = "This server is currently undergoing maintenance!";
    private String maintenanceIcon = "";
    private Schedule schedule = new Schedule();
    private boolean kickOnlinePlayers = true;
    private int configVersion = 3;
    private List<AllowedUser> allowedUsers = new ArrayList<AllowedUser>();

    public MaintenanceModeConfig(boolean wasReload) {
        super("mmode", "mmode.json");
        MaintenanceModeConfig.wasReload = wasReload;
        this.registerAndSetup(this);
    }

    public MaintenanceModeConfig() {
        this(false);
    }

    public void registerAndSetup(MaintenanceModeConfig config) {
        if (this.getConfigPath().exists() && this.getConfigPath().length() >= 2L) {
            this.migrateConfig(config);
        } else {
            this.saveConfig((Object)config);
        }
        if (!wasReload) {
            ConfigController.register_config((AbstractConfig)this);
        }
        this.configReloaded();
    }

    public void migrateConfig(MaintenanceModeConfig conf) {
        FileConfig config = FileConfig.builder((File)this.getConfigPath()).build();
        FileConfig newConfig = FileConfig.builder((File)this.getConfigPath()).sync().build();
        config.load();
        if ((Integer)config.getOrElse("configVersion", (Object)0) == configVer) {
            newConfig.close();
            config.close();
            return;
        }
        new ObjectConverter().toConfig((Object)conf, (Config)newConfig);
        AbstractConfigFormat abstractConfigFormat = this.getConfigFormat();
        if (abstractConfigFormat instanceof JsonConfigFormat) {
            JsonConfigFormat json = (JsonConfigFormat)abstractConfigFormat;
            json.updateConfigValues((Config)config, (Config)newConfig, (Config)newConfig, "");
        }
        newConfig.set("configVersion", (Object)configVer);
        try {
            FileUtils.copyFile((File)this.getConfigPath(), (File)new File(this.getConfigPath().getAbsolutePath().replace(".json", ".old")));
        }
        catch (IOException e) {
            ModConstants.LOG.warn("Failed to create config backup.", (Throwable)e);
        }
        newConfig.save();
        newConfig.close();
        config.close();
    }

    public void configReloaded() {
        INSTANCE = (MaintenanceModeConfig)((Object)this.readConfig((Object)this));
        hasConfigLoaded = true;
        CommonClass.INSTANCE.loadIcons();
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isDoBackup() {
        return this.doBackup;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getMotd() {
        return this.motd;
    }

    @Generated
    public String getMaintenanceIcon() {
        return this.maintenanceIcon;
    }

    @Generated
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Generated
    public boolean isKickOnlinePlayers() {
        return this.kickOnlinePlayers;
    }

    @Generated
    public int getConfigVersion() {
        return this.configVersion;
    }

    @Generated
    public List<AllowedUser> getAllowedUsers() {
        return this.allowedUsers;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setDoBackup(boolean doBackup) {
        this.doBackup = doBackup;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setMotd(String motd) {
        this.motd = motd;
    }

    @Generated
    public void setMaintenanceIcon(String maintenanceIcon) {
        this.maintenanceIcon = maintenanceIcon;
    }

    @Generated
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setKickOnlinePlayers(boolean kickOnlinePlayers) {
        this.kickOnlinePlayers = kickOnlinePlayers;
    }

    @Generated
    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    @Generated
    public void setAllowedUsers(List<AllowedUser> allowedUsers) {
        this.allowedUsers = allowedUsers;
    }

    static {
        configVer = 2;
        hasConfigLoaded = false;
        wasReload = false;
    }

    public static final class Schedule {
        private String startTime = "";
        private String endTime = "";
        private boolean disableOnRestart = false;
        private String maintanceNotifyMessage = "Maintenance is starting in %s minute(s)";

        @Generated
        public String getStartTime() {
            return this.startTime;
        }

        @Generated
        public String getEndTime() {
            return this.endTime;
        }

        @Generated
        public boolean isDisableOnRestart() {
            return this.disableOnRestart;
        }

        @Generated
        public String getMaintanceNotifyMessage() {
            return this.maintanceNotifyMessage;
        }

        @Generated
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Generated
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Generated
        public void setDisableOnRestart(boolean disableOnRestart) {
            this.disableOnRestart = disableOnRestart;
        }

        @Generated
        public void setMaintanceNotifyMessage(String maintanceNotifyMessage) {
            this.maintanceNotifyMessage = maintanceNotifyMessage;
        }

        @Generated
        public Schedule(String startTime, String endTime, boolean disableOnRestart, String maintanceNotifyMessage) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.disableOnRestart = disableOnRestart;
            this.maintanceNotifyMessage = maintanceNotifyMessage;
        }

        @Generated
        public Schedule() {
        }
    }

    public static final class AllowedUser {
        private String name;
        private String uuid;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getUuid() {
            return this.uuid;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Generated
        public AllowedUser(String name, String uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        @Generated
        public AllowedUser() {
        }
    }
}

