/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.commands;

import com.hypherionmc.craterlib.api.commands.CraterCommand;
import com.hypherionmc.craterlib.api.events.server.CraterRegisterCommandEvent;
import com.hypherionmc.craterlib.core.event.CraterEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.craterlib.nojang.commands.BridgedCommandSourceStack;
import com.hypherionmc.mmode.CommonClass;
import com.hypherionmc.mmode.ModConstants;
import com.hypherionmc.mmode.api.events.MaintenanceModeEvent;
import com.hypherionmc.mmode.config.MaintenanceModeConfig;
import com.hypherionmc.mmode.schedule.MaintenanceSchedule;
import com.hypherionmc.mmode.util.BackupUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import shadow.kyori.adventure.text.Component;
import shadow.kyori.adventure.text.format.NamedTextColor;
import shadow.kyori.adventure.text.format.TextColor;

public class MaintenanceModeCommand {
    public static void register(CraterRegisterCommandEvent event) {
        CraterCommand cmd = CraterCommand.literal((String)"maintenance").then(CraterCommand.literal((String)"status").requiresPermission(3).withNode("maintenance.status").execute(MaintenanceModeCommand::checkStatus)).then(CraterCommand.literal((String)"on").requiresPermission(3).withNode("maintenance.enable").execute(stack -> MaintenanceModeCommand.changeStatus(stack, true))).then(CraterCommand.literal((String)"off").requiresPermission(3).withNode("maintenance.disable").execute(ctx -> MaintenanceModeCommand.changeStatus(ctx, false))).then(CraterCommand.literal((String)"list").requiresPermission(3).withNode("maintenance.list").execute(MaintenanceModeCommand::listAllowedUsers)).then(CraterCommand.literal((String)"reload").requiresPermission(3).withNode("maintenance.reload").execute(MaintenanceModeCommand::reload)).then(CraterCommand.literal((String)"backup").requiresPermission(3).withNode("maintenance.backup").execute(MaintenanceModeCommand::doBackup)).then(CraterCommand.literal((String)"doBackups").requiresPermission(3).withNode("maintenance.setbackups").withBoolArgument("value", (player, value, ctx) -> MaintenanceModeCommand.changeBackups(ctx, value))).then(CraterCommand.literal((String)"setMessage").requiresPermission(3).withNode("maintenance.setmessage").withPhraseArgument("value", (player, value, ctx) -> MaintenanceModeCommand.setMessage(ctx, value))).then(CraterCommand.literal((String)"setMotd").requiresPermission(3).withNode("maintenance.setmotd").withPhraseArgument("value", (player, value, ctx) -> MaintenanceModeCommand.setMotd(ctx, value))).then(CraterCommand.literal((String)"addAllowed").requiresPermission(3).withNode("maintenance.adduser").withGameProfilesArgument("targets", (player, gameProfiles, ctx) -> MaintenanceModeCommand.addAllowedPlayer(ctx, gameProfiles))).then(CraterCommand.literal((String)"schedule").requiresPermission(3).withNode("maintenance.schedule").then(CraterCommand.literal((String)"disableOnRestart").requiresPermission(3).withNode("maintenance.changerestart").withBoolArgument("untilRestart", (ctx, value, stack) -> {
            MaintenanceModeConfig.INSTANCE.getSchedule().setDisableOnRestart((boolean)value);
            MaintenanceModeCommand.saveConfig(stack);
            return 1;
        })).then(CraterCommand.literal((String)"untilRestart").requiresPermission(3).withNode("maintenance.untilrestart").execute(MaintenanceModeCommand::scheduleTillRestart)).then(CraterCommand.literal((String)"repeating").then(CraterCommand.literal((String)"start").requiresPermission(3).withNode("maintenance.startschedule").withPhraseArgument("cron", (ctx, value, stack) -> MaintenanceModeCommand.scheduleStart(stack, value))).then(CraterCommand.literal((String)"end").requiresPermission(3).withNode("maintenance.endschedule").withPhraseArgument("cron", (ctx, value, stack) -> MaintenanceModeCommand.scheduleEnd(stack, value))))).then(CraterCommand.literal((String)"removeAllowed").requiresPermission(3).withNode("maintenance.removeuser").withGameProfilesArgument("targets", (player, gameProfiles, ctx) -> MaintenanceModeCommand.removeAllowedPlayer(ctx, gameProfiles)));
        event.registerCommand(cmd);
    }

    private static int scheduleTillRestart(BridgedCommandSourceStack stack) {
        CommonClass.INSTANCE.resetOnStartup = true;
        MaintenanceModeCommand.changeStatus(stack, true);
        stack.sendSuccess(() -> Component.text((String)"Maintenance is enabled until restart"), false);
        return 1;
    }

    private static int scheduleStart(BridgedCommandSourceStack stack, String value) {
        MaintenanceModeConfig.INSTANCE.getSchedule().setStartTime(value);
        CommonClass.INSTANCE.isDirty.set(true);
        MaintenanceSchedule.INSTANCE.initScheduler();
        try {
            MaintenanceModeConfig.INSTANCE.saveConfig((Object)MaintenanceModeConfig.INSTANCE);
        }
        catch (Exception e) {
            ModConstants.LOG.error("Failed to save config", (Throwable)e);
        }
        stack.sendSuccess(() -> Component.text((String)("Maintenance start schedule is set to " + value)), false);
        return 1;
    }

    private static int scheduleEnd(BridgedCommandSourceStack stack, String value) {
        MaintenanceModeConfig.INSTANCE.getSchedule().setEndTime(value);
        CommonClass.INSTANCE.isDirty.set(true);
        MaintenanceSchedule.INSTANCE.initScheduler();
        try {
            MaintenanceModeConfig.INSTANCE.saveConfig((Object)MaintenanceModeConfig.INSTANCE);
        }
        catch (Exception e) {
            ModConstants.LOG.error("Failed to save config", (Throwable)e);
        }
        stack.sendSuccess(() -> Component.text((String)("Maintenance end schedule is set to " + value)), false);
        return 1;
    }

    private static int doBackup(BridgedCommandSourceStack source) {
        try {
            source.sendSuccess(() -> Component.text((String)"Starting Maintenance Mode Backup"), false);
            BackupUtil.createBackup();
        }
        catch (Exception e) {
            ModConstants.LOG.error("Failed to create server backup: {}", (Object)e.getMessage());
            source.sendFailure((Component)Component.text((String)"Failed to create Server backup. Please check your server log"));
        }
        return 1;
    }

    private static int changeBackups(BridgedCommandSourceStack stack, boolean enabled) {
        if (MaintenanceModeConfig.INSTANCE == null) {
            new MaintenanceModeConfig();
        }
        MaintenanceModeConfig.INSTANCE.setDoBackup(enabled);
        MaintenanceModeCommand.saveConfig(stack);
        stack.sendSuccess(() -> Component.text((String)"Maintenance Mode Backups: ").append(Component.text((String)(enabled ? "Enabled" : "Disabled")).color((TextColor)NamedTextColor.YELLOW)), false);
        CommonClass.INSTANCE.isDirty.set(true);
        return 1;
    }

    private static int checkStatus(BridgedCommandSourceStack stack) {
        if (MaintenanceModeConfig.INSTANCE != null) {
            stack.sendSuccess(() -> Component.text((String)"Maintenance Mode: ").append(Component.text((String)(MaintenanceModeConfig.INSTANCE.isEnabled() ? "Enabled" : "Disabled")).color((TextColor)NamedTextColor.YELLOW)), false);
        } else {
            stack.sendFailure((Component)Component.text((String)"Maintenance Mode: Failed to load config"));
        }
        return 1;
    }

    public static int listAllowedUsers(BridgedCommandSourceStack stack) {
        String[] names;
        if (MaintenanceModeConfig.INSTANCE == null) {
            new MaintenanceModeConfig();
        }
        if ((names = (String[])MaintenanceModeConfig.INSTANCE.getAllowedUsers().stream().map(MaintenanceModeConfig.AllowedUser::getName).toArray(String[]::new)).length == 0) {
            stack.sendSuccess(() -> Component.text((String)"No users are allowed to join"), false);
        } else {
            stack.sendSuccess(() -> Component.text((String)String.format("There are %s allowed player(s): %s", names.length, String.join((CharSequence)", ", names))), false);
        }
        return 1;
    }

    private static int changeStatus(BridgedCommandSourceStack stack, boolean enabled) {
        block8: {
            if (MaintenanceModeConfig.INSTANCE == null) {
                new MaintenanceModeConfig();
            }
            MaintenanceModeConfig.INSTANCE.setEnabled(enabled);
            try {
                MaintenanceModeConfig.INSTANCE.saveConfig((Object)MaintenanceModeConfig.INSTANCE);
                if (!enabled) break block8;
                CommonClass.INSTANCE.kickAllPlayers(MaintenanceModeConfig.INSTANCE.getMessage());
                try {
                    if (MaintenanceModeConfig.INSTANCE.isDoBackup()) {
                        BackupUtil.createBackup();
                    }
                }
                catch (Exception e) {
                    ModConstants.LOG.error("Failed to save backup: {}", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                stack.sendFailure((Component)Component.text((String)"Failed to save config. Please see server log"));
                ModConstants.LOG.error("Failed to save config: {}", (Object)e.getMessage());
            }
        }
        stack.sendSuccess(() -> Component.text((String)"Maintenance Mode: ").append(Component.text((String)(MaintenanceModeConfig.INSTANCE.isEnabled() ? "Enabled" : "Disabled")).color((TextColor)NamedTextColor.YELLOW)), false);
        CommonClass.INSTANCE.isDirty.set(true);
        if (enabled) {
            CraterEventBus.INSTANCE.postEvent((CraterEvent)new MaintenanceModeEvent.MaintenanceStart());
        } else {
            CraterEventBus.INSTANCE.postEvent((CraterEvent)new MaintenanceModeEvent.MaintenanceEnd());
        }
        return 1;
    }

    private static int reload(BridgedCommandSourceStack stack) {
        new MaintenanceModeConfig(true);
        stack.sendSuccess(() -> Component.text((String)"Config Reloaded"), false);
        CommonClass.INSTANCE.isDirty.set(true);
        MaintenanceSchedule.INSTANCE.initScheduler();
        return 1;
    }

    private static int addAllowedPlayer(BridgedCommandSourceStack stack, Collection<BridgedGameProfile> gameProfiles) {
        if (MaintenanceModeConfig.INSTANCE == null) {
            new MaintenanceModeConfig();
        }
        ArrayList<MaintenanceModeConfig.AllowedUser> allowedUsers = MaintenanceModeConfig.INSTANCE.getAllowedUsers().isEmpty() ? new ArrayList() : MaintenanceModeConfig.INSTANCE.getAllowedUsers();
        for (BridgedGameProfile profile : gameProfiles) {
            if (allowedUsers.stream().noneMatch(allowedUser -> allowedUser.getUuid().equals(profile.getId().toString()))) {
                MaintenanceModeConfig.AllowedUser allowedUser2 = new MaintenanceModeConfig.AllowedUser(profile.getName(), profile.getId().toString());
                allowedUsers.add(allowedUser2);
                continue;
            }
            stack.sendFailure((Component)Component.text((String)"User already in allowed list"));
        }
        MaintenanceModeConfig.INSTANCE.setAllowedUsers(allowedUsers);
        MaintenanceModeCommand.saveConfig(stack);
        CommonClass.INSTANCE.isDirty.set(true);
        return 1;
    }

    private static int removeAllowedPlayer(BridgedCommandSourceStack stack, Collection<BridgedGameProfile> gameProfiles) {
        if (MaintenanceModeConfig.INSTANCE == null) {
            new MaintenanceModeConfig();
        }
        ArrayList<MaintenanceModeConfig.AllowedUser> allowedUsers = MaintenanceModeConfig.INSTANCE.getAllowedUsers().isEmpty() ? new ArrayList() : MaintenanceModeConfig.INSTANCE.getAllowedUsers();
        for (BridgedGameProfile profile : gameProfiles) {
            Optional<MaintenanceModeConfig.AllowedUser> allowedUserOptional = allowedUsers.stream().filter(allowedUser -> allowedUser.getUuid().equals(profile.getId().toString())).findFirst();
            if (allowedUserOptional.isPresent()) {
                allowedUsers.remove(allowedUserOptional.get());
                continue;
            }
            stack.sendFailure((Component)Component.text((String)"User not found in allowed list"));
            return 1;
        }
        MaintenanceModeConfig.INSTANCE.setAllowedUsers(allowedUsers);
        MaintenanceModeCommand.saveConfig(stack);
        CommonClass.INSTANCE.isDirty.set(true);
        CommonClass.INSTANCE.kickAllPlayers(MaintenanceModeConfig.INSTANCE.getMessage());
        return 1;
    }

    private static void saveConfig(BridgedCommandSourceStack stack) {
        try {
            MaintenanceModeConfig.INSTANCE.saveConfig((Object)MaintenanceModeConfig.INSTANCE);
        }
        catch (Exception e) {
            stack.sendFailure((Component)Component.text((String)"Failed to save config. Please see server log"));
            ModConstants.LOG.error("Failed to save config: {}", (Object)e.getMessage());
        }
        stack.sendSuccess(() -> Component.text((String)"Updated config"), false);
        CommonClass.INSTANCE.isDirty.set(true);
    }

    private static int setMessage(BridgedCommandSourceStack stack, String message) {
        if (MaintenanceModeConfig.INSTANCE == null) {
            new MaintenanceModeConfig();
        }
        MaintenanceModeConfig.INSTANCE.setMessage(message);
        MaintenanceModeCommand.saveConfig(stack);
        CommonClass.INSTANCE.isDirty.set(true);
        return 1;
    }

    private static int setMotd(BridgedCommandSourceStack stack, String message) {
        if (MaintenanceModeConfig.INSTANCE == null) {
            new MaintenanceModeConfig();
        }
        MaintenanceModeConfig.INSTANCE.setMotd(message);
        MaintenanceModeCommand.saveConfig(stack);
        CommonClass.INSTANCE.isDirty.set(true);
        return 1;
    }
}

