/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode;

import com.google.common.base.Preconditions;
import com.hypherionmc.craterlib.api.events.server.CraterRegisterCommandEvent;
import com.hypherionmc.craterlib.api.events.server.CraterServerLifecycleEvent;
import com.hypherionmc.craterlib.api.events.server.PlayerPreLoginEvent;
import com.hypherionmc.craterlib.api.events.server.ServerStatusEvent;
import com.hypherionmc.craterlib.core.event.annot.CraterEventListener;
import com.hypherionmc.craterlib.nojang.network.protocol.status.WrappedServerStatus;
import com.hypherionmc.craterlib.nojang.server.BridgedMinecraftServer;
import com.hypherionmc.craterlib.utils.ChatUtils;
import com.hypherionmc.mmode.ModConstants;
import com.hypherionmc.mmode.commands.MaintenanceModeCommand;
import com.hypherionmc.mmode.config.MaintenanceModeConfig;
import com.hypherionmc.mmode.schedule.MaintenanceSchedule;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import lombok.Generated;

public final class CommonClass {
    public static final CommonClass INSTANCE = new CommonClass();
    public AtomicBoolean isDirty = new AtomicBoolean(false);
    private BridgedMinecraftServer mcServer;
    private Optional<WrappedServerStatus.WrappedFavicon> favicon = Optional.empty();
    private Optional<WrappedServerStatus.WrappedFavicon> backupIcon = Optional.empty();
    public boolean resetOnStartup = false;

    @CraterEventListener
    public void serverStartedEvent(CraterServerLifecycleEvent.Started event) {
        new MaintenanceModeConfig();
        this.mcServer = event.getServer();
        MaintenanceSchedule.INSTANCE.initScheduler();
        this.loadIcons();
        if (MaintenanceModeConfig.INSTANCE != null) {
            ModConstants.LOG.info(MaintenanceModeConfig.INSTANCE.isEnabled() ? "Maintenance mode is active!" : "Maintenance mode is off");
        }
    }

    @CraterEventListener
    public void registerCommandEvent(CraterRegisterCommandEvent event) {
        MaintenanceModeCommand.register(event);
    }

    @CraterEventListener
    public void playerPreLoginEvent(PlayerPreLoginEvent event) {
        if (MaintenanceModeConfig.INSTANCE.isEnabled() && MaintenanceModeConfig.INSTANCE.getAllowedUsers().stream().noneMatch(allowedUser -> allowedUser.getUuid().equals(event.getGameProfile().getId().toString()))) {
            String message = MaintenanceModeConfig.INSTANCE.getMessage();
            if (message == null || message.isEmpty()) {
                message = "Server is currently undergoing maintenance. Please try connecting again later";
            }
            event.setMessage(ChatUtils.format((String)message));
        }
    }

    @CraterEventListener
    public void requestFavIconEvent(ServerStatusEvent.FaviconRequestEvent event) {
        if (!MaintenanceModeConfig.INSTANCE.isEnabled() && this.backupIcon.isPresent()) {
            event.setNewIcon(this.backupIcon);
        }
        if (MaintenanceModeConfig.INSTANCE.isEnabled() && this.favicon.isPresent()) {
            event.setNewIcon(this.favicon);
        }
    }

    @CraterEventListener
    public void requestServerStatus(ServerStatusEvent.StatusRequestEvent event) {
        String message;
        if (MaintenanceModeConfig.INSTANCE.isEnabled() && (message = MaintenanceModeConfig.INSTANCE.getMotd()) != null && !message.isEmpty()) {
            event.setNewStatus(ChatUtils.format((String)message));
        }
    }

    @CraterEventListener
    public void serverShutdownEvent(CraterServerLifecycleEvent.Stopped event) {
        if (this.resetOnStartup && MaintenanceModeConfig.INSTANCE.isEnabled()) {
            MaintenanceModeConfig.INSTANCE.setEnabled(false);
            MaintenanceModeConfig.INSTANCE.saveConfig((Object)MaintenanceModeConfig.INSTANCE);
        }
        MaintenanceSchedule.INSTANCE.shutDown();
    }

    public void loadIcons() {
        if (MaintenanceModeConfig.INSTANCE.getMaintenanceIcon() != null && !MaintenanceModeConfig.INSTANCE.getMaintenanceIcon().isEmpty()) {
            File file = new File(MaintenanceModeConfig.INSTANCE.getMaintenanceIcon());
            if (!file.exists()) {
                return;
            }
            this.favicon = this.loadIcon(file);
        }
        if (!new File("server-icon.png").exists()) {
            this.backupIcon = this.loadIcon(Thread.currentThread().getContextClassLoader().getResourceAsStream("mmicon.png"));
        }
    }

    public void kickAllPlayers(String message) {
        if (MaintenanceModeConfig.INSTANCE != null && !MaintenanceModeConfig.INSTANCE.isKickOnlinePlayers()) {
            return;
        }
        if (this.mcServer != null) {
            this.mcServer.getPlayers().forEach(serverPlayer -> {
                if (MaintenanceModeConfig.INSTANCE.getAllowedUsers().stream().noneMatch(allowedUser -> allowedUser.getUuid().equals(serverPlayer.getStringUUID()))) {
                    serverPlayer.disconnect(ChatUtils.format((String)message));
                }
            });
        }
    }

    public void broadcastMessage(String message) {
        if (this.mcServer != null) {
            this.mcServer.broadcastSystemMessage(ChatUtils.format((String)message), false);
        }
    }

    private Optional<WrappedServerStatus.WrappedFavicon> loadIcon(File file) {
        try {
            return this.loadIcon(new FileInputStream(file));
        }
        catch (Exception e) {
            ModConstants.LOG.error("Failed to load icon", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<WrappedServerStatus.WrappedFavicon> loadIcon(InputStream inputStream) {
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
            Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", outputStream);
            return Optional.of(new WrappedServerStatus.WrappedFavicon(outputStream.toByteArray()));
        }
        catch (Exception e) {
            ModConstants.LOG.error("Failed to load icon", (Throwable)e);
            return Optional.empty();
        }
    }

    @Generated
    private CommonClass() {
    }
}

